/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.mappers;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.misc.CharPredicate;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.util.function.Consumer;

public class SpecialLeadInCharsHandler
implements SpecialLeadInHandler {
    final CharPredicate predicate;

    protected SpecialLeadInCharsHandler(CharPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean escape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
        if (sequence.length() == 1 && this.predicate.test(sequence.charAt(0))) {
            consumer.accept("\\");
            consumer.accept(sequence);
            return true;
        }
        return false;
    }

    @Override
    public boolean unEscape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
        if (sequence.length() == 2 && sequence.charAt(0) == '\\' && this.predicate.test(sequence.charAt(1))) {
            consumer.accept((CharSequence)sequence.subSequence(1));
            return true;
        }
        return false;
    }

    @NotNull
    public static SpecialLeadInCharsHandler create(char leadInChar) {
        return new SpecialLeadInCharsHandler(CharPredicate.anyOf(leadInChar));
    }

    @NotNull
    public static SpecialLeadInCharsHandler create(@NotNull CharSequence leadInChar) {
        return new SpecialLeadInCharsHandler(CharPredicate.anyOf(leadInChar));
    }
}

